using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using TABLE = gov.va.med.vbecs.Common.VbecsTables.LocalSupplier;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgFacilitySearch
	/// </summary>
	public class DlgFacilitySearch : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		
		/// <summary>
		/// _isNational
		/// </summary>
		private bool _isNational;

		/// <summary>
		/// _facilityList
		/// </summary>
		private DataTable _facilityList;

		/// <summary>
		/// _selectedIndex
		/// </summary>
		private int _selectedIndex;

		/// <summary>
		/// Did the search criteria entered return any data?
		/// </summary>
		private bool _noDataFound;

		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.Button btnSearch;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.GroupBox grpSelected;
		private System.Windows.Forms.TextBox txtFacilityName;
		private System.Windows.Forms.Label lblFacilityName;
		private System.Windows.Forms.Label lblFacilityAddress;
		private System.Windows.Forms.TextBox txtFacilityAddress;
		private System.Windows.Forms.Label lblFDARegNo;
		private System.Windows.Forms.TextBox txtFDARegNo;
		private System.Windows.Forms.Label lblFDARegSearch;
		private System.Windows.Forms.Label lblFacilityNameSearch;
		private System.Windows.Forms.TextBox txtFacilityNameSearch;
		private System.Windows.Forms.ListView lvFacilities;
		private System.Windows.Forms.ColumnHeader colFDAReg;
		private System.Windows.Forms.ColumnHeader colName;
		private System.Windows.Forms.Label lblFax;
		private System.Windows.Forms.Label lblPhone;
		private System.Windows.Forms.TextBox txtFDARegSearch;
		private System.Windows.Forms.TextBox txtPhone;
		private System.Windows.Forms.TextBox txtFax;
		private System.Windows.Forms.CheckBox chkTestingFacility;
		private System.Windows.Forms.CheckBox chkCollectionFacility;
		private System.Windows.Forms.Label lblCollectionFacility;
		private System.Windows.Forms.Label lblTestingFacility;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.CheckBox cbActiveFacility;
		private System.Windows.Forms.Label lblActiveFacility;
		private System.Windows.Forms.Label lblICCBBA;
		private System.Windows.Forms.TextBox txtICCBBA;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Contructors/Dispose

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/11/2003</CreationDate>
		///<summary>Search form -- no constructor logic needed</summary>
		public DlgFacilitySearch()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/26/2003</CreationDate>
		///<summary>Search form -- no constructor logic needed</summary>
		public DlgFacilitySearch(string fdaRegistrationNumber)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			
			if (fdaRegistrationNumber.Length > 0)
			{
				//defult the FDA Registration Number to data passed in and enable search
				this.txtFDARegSearch.Text = fdaRegistrationNumber;
				this.btnSearch.Enabled = this.EnableSearchButton();
			}
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgFacilitySearch));
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.txtFDARegSearch = new System.Windows.Forms.TextBox();
			this.lblFDARegSearch = new System.Windows.Forms.Label();
			this.btnSearch = new System.Windows.Forms.Button();
			this.txtFacilityNameSearch = new System.Windows.Forms.TextBox();
			this.lblFacilityNameSearch = new System.Windows.Forms.Label();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lvFacilities = new System.Windows.Forms.ListView();
			this.colFDAReg = new System.Windows.Forms.ColumnHeader();
			this.colName = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.grpSelected = new System.Windows.Forms.GroupBox();
			this.txtICCBBA = new System.Windows.Forms.TextBox();
			this.lblICCBBA = new System.Windows.Forms.Label();
			this.lblActiveFacility = new System.Windows.Forms.Label();
			this.cbActiveFacility = new System.Windows.Forms.CheckBox();
			this.lblTestingFacility = new System.Windows.Forms.Label();
			this.lblCollectionFacility = new System.Windows.Forms.Label();
			this.chkTestingFacility = new System.Windows.Forms.CheckBox();
			this.chkCollectionFacility = new System.Windows.Forms.CheckBox();
			this.txtFax = new System.Windows.Forms.TextBox();
			this.txtPhone = new System.Windows.Forms.TextBox();
			this.lblFax = new System.Windows.Forms.Label();
			this.lblPhone = new System.Windows.Forms.Label();
			this.txtFacilityName = new System.Windows.Forms.TextBox();
			this.lblFacilityName = new System.Windows.Forms.Label();
			this.lblFacilityAddress = new System.Windows.Forms.Label();
			this.txtFacilityAddress = new System.Windows.Forms.TextBox();
			this.lblFDARegNo = new System.Windows.Forms.Label();
			this.txtFDARegNo = new System.Windows.Forms.TextBox();
			this.grpSearch.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpResults.SuspendLayout();
			this.grpSelected.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(564, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Facility Search";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 417);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpSearch
			// 
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.txtFDARegSearch);
			this.grpSearch.Controls.Add(this.lblFDARegSearch);
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Controls.Add(this.txtFacilityNameSearch);
			this.grpSearch.Controls.Add(this.lblFacilityNameSearch);
			this.grpSearch.Location = new System.Drawing.Point(60, 32);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(292, 68);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criteria*";
			// 
			// txtFDARegSearch
			// 
			this.txtFDARegSearch.AccessibleDescription = "F D A Registration Number";
			this.txtFDARegSearch.AccessibleName = "F D A Registration Number";
			this.txtFDARegSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFDARegSearch.Location = new System.Drawing.Point(112, 40);
			this.txtFDARegSearch.MaxLength = 10;
			this.txtFDARegSearch.Name = "txtFDARegSearch";
			this.txtFDARegSearch.Size = new System.Drawing.Size(96, 20);
			this.txtFDARegSearch.TabIndex = 2;
			this.txtFDARegSearch.Text = "";
			this.txtFDARegSearch.TextChanged += new System.EventHandler(this.txtFDARegSearch_TextChanged);
			// 
			// lblFDARegSearch
			// 
			this.lblFDARegSearch.Location = new System.Drawing.Point(8, 40);
			this.lblFDARegSearch.Name = "lblFDARegSearch";
			this.lblFDARegSearch.Size = new System.Drawing.Size(80, 20);
			this.lblFDARegSearch.TabIndex = 2;
			this.lblFDARegSearch.Text = "FDA Reg. No.";
			this.lblFDARegSearch.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Enabled = false;
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnSearch.Location = new System.Drawing.Point(210, 38);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.TabIndex = 3;
			this.btnSearch.Text = "&Search";
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtFacilityNameSearch
			// 
			this.txtFacilityNameSearch.AccessibleDescription = "Partial Facility Name";
			this.txtFacilityNameSearch.AccessibleName = "Partial Facility Name";
			this.txtFacilityNameSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFacilityNameSearch.Location = new System.Drawing.Point(112, 16);
			this.txtFacilityNameSearch.MaxLength = 40;
			this.txtFacilityNameSearch.Name = "txtFacilityNameSearch";
			this.txtFacilityNameSearch.Size = new System.Drawing.Size(172, 20);
			this.txtFacilityNameSearch.TabIndex = 1;
			this.txtFacilityNameSearch.Text = "";
			this.txtFacilityNameSearch.TextChanged += new System.EventHandler(this.txtFacilityNameSearch_TextChanged);
			// 
			// lblFacilityNameSearch
			// 
			this.lblFacilityNameSearch.Location = new System.Drawing.Point(8, 16);
			this.lblFacilityNameSearch.Name = "lblFacilityNameSearch";
			this.lblFacilityNameSearch.Size = new System.Drawing.Size(108, 20);
			this.lblFacilityNameSearch.TabIndex = 0;
			this.lblFacilityNameSearch.Text = "Partial Facility Name";
			this.lblFacilityNameSearch.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 364);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lvFacilities);
			this.grpResults.Location = new System.Drawing.Point(60, 104);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(292, 292);
			this.grpResults.TabIndex = 1;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lvFacilities
			// 
			this.lvFacilities.AccessibleDescription = "Search Results";
			this.lvFacilities.AccessibleName = "Search Results";
			this.lvFacilities.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvFacilities.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.colFDAReg,
																						   this.colName});
			this.lvFacilities.FullRowSelect = true;
			this.lvFacilities.HideSelection = false;
			this.lvFacilities.Location = new System.Drawing.Point(8, 16);
			this.lvFacilities.MultiSelect = false;
			this.lvFacilities.Name = "lvFacilities";
			this.lvFacilities.Size = new System.Drawing.Size(278, 268);
			this.lvFacilities.TabIndex = 4;
			this.lvFacilities.View = System.Windows.Forms.View.Details;
			this.lvFacilities.DoubleClick += new System.EventHandler(this.lvFacilities_DoubleClick);
			this.lvFacilities.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvFacilities_ColumnClick);
			this.lvFacilities.SelectedIndexChanged += new System.EventHandler(this.lvFacilities_SelectedIndexChanged);
			// 
			// colFDAReg
			// 
			this.colFDAReg.Text = "FDA Reg. No.";
			this.colFDAReg.Width = 80;
			// 
			// colName
			// 
			this.colName.Text = "Facility Name";
			this.colName.Width = 200;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(488, 401);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 15;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Enabled = false;
			this.btnOK.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnOK.Location = new System.Drawing.Point(408, 401);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 14;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpSelected
			// 
			this.grpSelected.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelected.Controls.Add(this.txtICCBBA);
			this.grpSelected.Controls.Add(this.lblICCBBA);
			this.grpSelected.Controls.Add(this.lblActiveFacility);
			this.grpSelected.Controls.Add(this.cbActiveFacility);
			this.grpSelected.Controls.Add(this.lblTestingFacility);
			this.grpSelected.Controls.Add(this.lblCollectionFacility);
			this.grpSelected.Controls.Add(this.chkTestingFacility);
			this.grpSelected.Controls.Add(this.chkCollectionFacility);
			this.grpSelected.Controls.Add(this.txtFax);
			this.grpSelected.Controls.Add(this.txtPhone);
			this.grpSelected.Controls.Add(this.lblFax);
			this.grpSelected.Controls.Add(this.lblPhone);
			this.grpSelected.Controls.Add(this.txtFacilityName);
			this.grpSelected.Controls.Add(this.lblFacilityName);
			this.grpSelected.Controls.Add(this.lblFacilityAddress);
			this.grpSelected.Controls.Add(this.txtFacilityAddress);
			this.grpSelected.Controls.Add(this.lblFDARegNo);
			this.grpSelected.Controls.Add(this.txtFDARegNo);
			this.grpSelected.Location = new System.Drawing.Point(356, 32);
			this.grpSelected.Name = "grpSelected";
			this.grpSelected.Size = new System.Drawing.Size(206, 364);
			this.grpSelected.TabIndex = 2;
			this.grpSelected.TabStop = false;
			this.grpSelected.Text = "Selected Facility";
			// 
			// txtICCBBA
			// 
			this.txtICCBBA.AccessibleDescription = "I C C B B A Registration Number";
			this.txtICCBBA.AccessibleName = "I C C B B A Registration Number";
			this.txtICCBBA.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtICCBBA.Location = new System.Drawing.Point(104, 48);
			this.txtICCBBA.Name = "txtICCBBA";
			this.txtICCBBA.ReadOnly = true;
			this.txtICCBBA.Size = new System.Drawing.Size(88, 20);
			this.txtICCBBA.TabIndex = 6;
			this.txtICCBBA.Text = "";
			// 
			// lblICCBBA
			// 
			this.lblICCBBA.Location = new System.Drawing.Point(8, 48);
			this.lblICCBBA.Name = "lblICCBBA";
			this.lblICCBBA.Size = new System.Drawing.Size(96, 20);
			this.lblICCBBA.TabIndex = 2;
			this.lblICCBBA.Text = "ICCBBA Reg. No.";
			this.lblICCBBA.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblActiveFacility
			// 
			this.lblActiveFacility.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblActiveFacility.Location = new System.Drawing.Point(8, 344);
			this.lblActiveFacility.Name = "lblActiveFacility";
			this.lblActiveFacility.Size = new System.Drawing.Size(164, 16);
			this.lblActiveFacility.TabIndex = 16;
			this.lblActiveFacility.Text = "Active Facility?";
			this.lblActiveFacility.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbActiveFacility
			// 
			this.cbActiveFacility.AccessibleDescription = "Active Facility";
			this.cbActiveFacility.AccessibleName = "Active Facility";
			this.cbActiveFacility.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cbActiveFacility.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbActiveFacility.Enabled = false;
			this.cbActiveFacility.Location = new System.Drawing.Point(8, 344);
			this.cbActiveFacility.Name = "cbActiveFacility";
			this.cbActiveFacility.Size = new System.Drawing.Size(184, 16);
			this.cbActiveFacility.TabIndex = 13;
			this.cbActiveFacility.Text = "Active Facility?";
			// 
			// lblTestingFacility
			// 
			this.lblTestingFacility.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblTestingFacility.Location = new System.Drawing.Point(8, 320);
			this.lblTestingFacility.Name = "lblTestingFacility";
			this.lblTestingFacility.Size = new System.Drawing.Size(164, 16);
			this.lblTestingFacility.TabIndex = 14;
			this.lblTestingFacility.Text = "Testing Facility?";
			this.lblTestingFacility.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCollectionFacility
			// 
			this.lblCollectionFacility.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblCollectionFacility.Location = new System.Drawing.Point(8, 296);
			this.lblCollectionFacility.Name = "lblCollectionFacility";
			this.lblCollectionFacility.Size = new System.Drawing.Size(164, 16);
			this.lblCollectionFacility.TabIndex = 12;
			this.lblCollectionFacility.Text = "Collection Facility?";
			this.lblCollectionFacility.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// chkTestingFacility
			// 
			this.chkTestingFacility.AccessibleDescription = "Testing Faciltiy";
			this.chkTestingFacility.AccessibleName = "Testing Faciltiy";
			this.chkTestingFacility.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.chkTestingFacility.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.chkTestingFacility.Enabled = false;
			this.chkTestingFacility.Location = new System.Drawing.Point(8, 320);
			this.chkTestingFacility.Name = "chkTestingFacility";
			this.chkTestingFacility.Size = new System.Drawing.Size(184, 16);
			this.chkTestingFacility.TabIndex = 12;
			this.chkTestingFacility.Text = "Testing Facility?";
			// 
			// chkCollectionFacility
			// 
			this.chkCollectionFacility.AccessibleDescription = "Collection Facility";
			this.chkCollectionFacility.AccessibleName = "Collection Facility";
			this.chkCollectionFacility.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.chkCollectionFacility.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.chkCollectionFacility.Enabled = false;
			this.chkCollectionFacility.Location = new System.Drawing.Point(8, 296);
			this.chkCollectionFacility.Name = "chkCollectionFacility";
			this.chkCollectionFacility.Size = new System.Drawing.Size(184, 16);
			this.chkCollectionFacility.TabIndex = 11;
			this.chkCollectionFacility.Text = "Collection Facility?";
			// 
			// txtFax
			// 
			this.txtFax.AccessibleDescription = "Fax";
			this.txtFax.AccessibleName = "Fax";
			this.txtFax.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.txtFax.Location = new System.Drawing.Point(88, 272);
			this.txtFax.Name = "txtFax";
			this.txtFax.ReadOnly = true;
			this.txtFax.Size = new System.Drawing.Size(104, 20);
			this.txtFax.TabIndex = 10;
			this.txtFax.Text = "";
			// 
			// txtPhone
			// 
			this.txtPhone.AccessibleDescription = "Phone";
			this.txtPhone.AccessibleName = "Phone";
			this.txtPhone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPhone.Location = new System.Drawing.Point(88, 248);
			this.txtPhone.Name = "txtPhone";
			this.txtPhone.ReadOnly = true;
			this.txtPhone.Size = new System.Drawing.Size(104, 20);
			this.txtPhone.TabIndex = 9;
			this.txtPhone.Text = "";
			// 
			// lblFax
			// 
			this.lblFax.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblFax.Image = ((System.Drawing.Image)(resources.GetObject("lblFax.Image")));
			this.lblFax.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.lblFax.Location = new System.Drawing.Point(8, 272);
			this.lblFax.Name = "lblFax";
			this.lblFax.Size = new System.Drawing.Size(60, 20);
			this.lblFax.TabIndex = 10;
			this.lblFax.Text = "Fax";
			this.lblFax.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblPhone
			// 
			this.lblPhone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblPhone.Image = ((System.Drawing.Image)(resources.GetObject("lblPhone.Image")));
			this.lblPhone.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.lblPhone.Location = new System.Drawing.Point(8, 248);
			this.lblPhone.Name = "lblPhone";
			this.lblPhone.Size = new System.Drawing.Size(72, 20);
			this.lblPhone.TabIndex = 8;
			this.lblPhone.Text = "Phone";
			this.lblPhone.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtFacilityName
			// 
			this.txtFacilityName.AccessibleDescription = "Facility Name";
			this.txtFacilityName.AccessibleName = "Facility Name";
			this.txtFacilityName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFacilityName.Location = new System.Drawing.Point(8, 88);
			this.txtFacilityName.Name = "txtFacilityName";
			this.txtFacilityName.ReadOnly = true;
			this.txtFacilityName.Size = new System.Drawing.Size(184, 20);
			this.txtFacilityName.TabIndex = 7;
			this.txtFacilityName.Text = "";
			// 
			// lblFacilityName
			// 
			this.lblFacilityName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblFacilityName.Location = new System.Drawing.Point(8, 72);
			this.lblFacilityName.Name = "lblFacilityName";
			this.lblFacilityName.Size = new System.Drawing.Size(190, 16);
			this.lblFacilityName.TabIndex = 4;
			this.lblFacilityName.Text = "Facility Name";
			this.lblFacilityName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblFacilityAddress
			// 
			this.lblFacilityAddress.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblFacilityAddress.Location = new System.Drawing.Point(8, 112);
			this.lblFacilityAddress.Name = "lblFacilityAddress";
			this.lblFacilityAddress.Size = new System.Drawing.Size(190, 16);
			this.lblFacilityAddress.TabIndex = 6;
			this.lblFacilityAddress.Text = "Facility Address";
			this.lblFacilityAddress.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtFacilityAddress
			// 
			this.txtFacilityAddress.AccessibleDescription = "Facility Address";
			this.txtFacilityAddress.AccessibleName = "Facility Address";
			this.txtFacilityAddress.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFacilityAddress.Location = new System.Drawing.Point(8, 128);
			this.txtFacilityAddress.Multiline = true;
			this.txtFacilityAddress.Name = "txtFacilityAddress";
			this.txtFacilityAddress.ReadOnly = true;
			this.txtFacilityAddress.Size = new System.Drawing.Size(184, 112);
			this.txtFacilityAddress.TabIndex = 8;
			this.txtFacilityAddress.Text = "";
			// 
			// lblFDARegNo
			// 
			this.lblFDARegNo.Location = new System.Drawing.Point(8, 20);
			this.lblFDARegNo.Name = "lblFDARegNo";
			this.lblFDARegNo.Size = new System.Drawing.Size(80, 20);
			this.lblFDARegNo.TabIndex = 0;
			this.lblFDARegNo.Text = "FDA Reg. No.";
			this.lblFDARegNo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtFDARegNo
			// 
			this.txtFDARegNo.AccessibleDescription = "F D A Registration Number";
			this.txtFDARegNo.AccessibleName = "F D A Registration Number";
			this.txtFDARegNo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFDARegNo.Location = new System.Drawing.Point(88, 20);
			this.txtFDARegNo.Name = "txtFDARegNo";
			this.txtFDARegNo.ReadOnly = true;
			this.txtFDARegNo.Size = new System.Drawing.Size(104, 20);
			this.txtFDARegNo.TabIndex = 5;
			this.txtFDARegNo.Text = "";
			// 
			// DlgFacilitySearch
			// 
			this.AcceptButton = this.btnSearch;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(564, 433);
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpSelected);
			this.hlphelpChm.SetHelpKeyword(this, "Local_Facilities.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(572, 424);
			this.Name = "DlgFacilitySearch";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Facility Search";
			this.Controls.SetChildIndex(this.grpSelected, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpSearch.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpResults.ResumeLayout(false);
			this.grpSelected.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Control Events

		/// <summary>
		/// Process the facility list click
		/// </summary>
		private void lvFacilities_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.ResetLockTimer(this, System.EventArgs.Empty);
				//This event is stupid... It gets called twice per "click" 
				//I think once to unselect the current item, and once to select the new one....pfffft. Microsoft.
				if (this.lvFacilities.SelectedItems.Count != 0)
				{
					if (!this._noDataFound)
					{
						this._selectedIndex = this.lvFacilities.SelectedItems[0].Index;

						this._isNational = ((DataRow)this.lvFacilities.Items[this._selectedIndex].Tag).IsNull(TABLE.LocalSupplierGuid);

						this.PopulateFormData();
					}
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}


		/// <summary>
		/// If the user double-clicks a facility -- automatically take them back to the calling form
		/// </summary>
		private void lvFacilities_DoubleClick(object sender, System.EventArgs e)
		{
			if (!this._noDataFound)
			{
				this.btnOK_Click(null,System.EventArgs.Empty);		
			}
		}

		/// <summary>
		/// Process the Search button click
		/// </summary>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			this.InitializeFields();
			this.FacilitySearch();
		}

		/// <summary>
		/// txtFacilityNameSearch_TextChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtFacilityNameSearch_TextChanged(object sender, System.EventArgs e)
		{
			btnSearch.Enabled = this.EnableSearchButton();
		}

		/// <summary>
		/// txtFDARegSearch_TextChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtFDARegSearch_TextChanged(object sender, System.EventArgs e)
		{
			btnSearch.Enabled = this.EnableSearchButton();
		}


		/// <summary>
		/// Close the form.  The collection facility is accessed via a Form-level Property
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// Close the dialog, setting the result to indicate no selection was made
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		}

		private void lvFacilities_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvFacilities.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		#endregion

		#region Properties

		/// <summary>
		/// ReadOnly --- the FDAR # that was selected 
		/// </summary>
		public string FdaRegistrationNumber
		{
			get
			{
				return this.txtFDARegNo.Text;
			}
		}


		/// <summary>
		/// Read-Only -- the selected facility #
		/// </summary>
		private string SelectedFdaRegistrationNumber
		{
			get
			{
				if ( this.lvFacilities.Items.Count == 0 || ((DataRow)this.lvFacilities.Items[this._selectedIndex].Tag).IsNull(TABLE.FdaRegistrationNumber))
				{
					return String.Empty;
				}
				else
				{
					return ((DataRow)this.lvFacilities.Items[this._selectedIndex].Tag)[TABLE.FdaRegistrationNumber].ToString();
				}
			}
		}

		/// <summary>
		/// SelectedFacilityGUID
		/// </summary>
		public System.Guid SelectedFacilityGuid
		{
			get
			{
				if ( this.lvFacilities.Items.Count == 0 || ((DataRow)this.lvFacilities.Items[this._selectedIndex].Tag).IsNull(Common.VbecsTables.Facility.FacilityGuid))
				{
					return System.Guid.Empty;
				}
				else
				{
					return (System.Guid)((DataRow)this.lvFacilities.Items[this._selectedIndex].Tag)[Common.VbecsTables.Facility.FacilityGuid];
				}
			}
		}

		/// <summary>
		/// Read-Only -- if the selected facility is a national entry
		/// </summary>
		public bool IsNational
		{
			get
			{
				return this._isNational;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// Only enable the search button if they've typed something to search on
		/// </summary>
		private bool EnableSearchButton()
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			return ((txtFacilityNameSearch.Text.Length > 0) || (txtFDARegSearch.Text.Length > 0));
		}

		/// <summary>
		/// Set the form's initial properties since we all inherit from a base form
		/// </summary>
		private void SetComponentProperties()
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			this.vbecsLogo1.Title = "Facility Search";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC006.DlgFacilitySearch());
		}


		/// <summary>
		/// Get the list of facilities (if any)
		/// </summary>		
		private void FacilitySearch()
		{
			try
			{
				this.Working();
			
				this._facilityList = BOL.LocalSupplier.GetLocalSupplierLookupList(txtFacilityNameSearch.Text, txtFDARegSearch.Text);
				LoadFacilities();
			}
			catch( Exception )
			{
				this.Stopped();
				throw;
			}
			finally
			{
				this.Ready();
			}	
		}
		
		/// <summary>
		/// Load the Listview with the facilityList.  Display a message if no data was returned.
		/// </summary>
		private void LoadFacilities()
		{
			lvFacilities.Items.Clear();

			//In case no data comes back... at least the user will be informed.
			if (this._facilityList.Rows.Count == 0)
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Text = "No data to display.";
				this.lvFacilities.Items.Add(lvi);
				this._noDataFound = true;
			}

			foreach (System.Data.DataRow dr in this._facilityList.Rows)
			{			
				ListViewItem lvi = new ListViewItem();

				lvi.Text = dr[TABLE.FdaRegistrationNumber].ToString();
				lvi.SubItems.Add(dr[TABLE.FacilityName].ToString());
				lvi.Tag = dr;
				this.lvFacilities.Items.Add(lvi);
				this._noDataFound = false;
			}

			controls.VbecsFunction.SetColumnWidths(this.lvFacilities);
		}


		/// <summary>
		/// Fill the screen with the facility data.. Address, Facility Indicators, etc..
		/// </summary>
		private void PopulateFormData()
		{
			try
			{
				System.Collections.ArrayList addrBuilder = new System.Collections.ArrayList();

				BOL.LocalSupplier _localSupplier = new BOL.LocalSupplier(this.SelectedFdaRegistrationNumber, false);

				this.txtFDARegNo.Text = _localSupplier.FDARegistrationNumber;
				this.txtFacilityName.Text = _localSupplier.FacilityName;

				//Build the Address for the Multi-Line textbox
				if (_localSupplier.HasAddress)
				{
					addrBuilder.Add(_localSupplier.Address.AddressLine1);

					if (!_localSupplier.Address.AddressLine2.Equals(String.Empty))
					{
						addrBuilder.Add(_localSupplier.Address.AddressLine2);
					}

					if (!_localSupplier.Address.AddressLine3.Equals(String.Empty))
					{
						addrBuilder.Add(_localSupplier.Address.AddressLine3);
					}

					if (!_localSupplier.Address.City.Equals(String.Empty))
					{
						addrBuilder.Add(_localSupplier.Address.City);
					}

					if(!_localSupplier.Address.StateCode.Equals(String.Empty))
					{
						string zipcode = string.Empty;

						if (!_localSupplier.Address.ZipCode.Equals(String.Empty))
						{
							zipcode = _localSupplier.Address.ZipCode;
						}

						addrBuilder.Add(_localSupplier.Address.StateCode + ", " + zipcode);
					}


					this.txtFacilityAddress.Lines = (string[])addrBuilder.ToArray(typeof(string));
				}
				else
				{
					this.txtFacilityAddress.Text = String.Empty;
				}

				//12/30/2004 - Lohse - Adding ICCBBA Number
				this.txtICCBBA.Text = _localSupplier.IccbbaRegistrationNumber;

				this.txtPhone.Text = _localSupplier.PhoneNumber;
				this.txtFax.Text = _localSupplier.FaxNumber;

				this.chkCollectionFacility.Checked = _localSupplier.IsCollectionFacility;
				this.chkTestingFacility.Checked = _localSupplier.IsTestingFacility;
				
				//Check if the selected Facility is National
				if (this._isNational == true)
				{
					//by default make it inactive
					this.cbActiveFacility.Checked = false;
				}
				else if(_localSupplier.RecordStatusCode == Common.RecordStatusCode.Inactive)
				{
					//Local Supplier has beed already inactivated
					this.cbActiveFacility.Checked = false;
				}
				else
				{
					this.cbActiveFacility.Checked = true;
				}
				this.btnOK.Enabled = true;
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		
		/// <summary>
		/// Reset all the form control values
		/// </summary>
		private bool InitializeFields()
		{
            this.txtFDARegNo.Text = String.Empty;
			this.txtFacilityAddress.Text = String.Empty;
			this.txtPhone.Text = String.Empty;
			this.txtFax.Text = String.Empty;
			this.chkCollectionFacility.Checked = false;
			this.chkTestingFacility.Checked = false;
			this.cbActiveFacility.Checked = false;

			this.btnOK.Enabled = false;
			return true;
		}


		#endregion

	}
}

